'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';
const RESOURCES = {
  "assets/AssetManifest.json": "c11be2022b029f5b5f97e1dfc629531c",
"assets/assets/fonts/Montserrat-Bold.ttf": "ade91f473255991f410f61857696434b",
"assets/assets/fonts/Montserrat-Regular.ttf": "ee6539921d713482b8ccd4d0d23961bb",
"assets/assets/fonts/Montserrat-SemiBold.ttf": "c641dbee1d75892e4d88bdc31560c91b",
"assets/assets/icons/Call.svg": "66eb49b3b15d8c8aadc79a1871709bf3",
"assets/assets/icons/Camera%2520Icon.svg": "2a6c1909e2d6d9abb570b938094ee44c",
"assets/assets/icons/Error.svg": "0f876e9b9170982e37bbf767c6ebb47f",
"assets/assets/icons/Lock.svg": "44a5fb6d11a48fd52c87d95e34e7a689",
"assets/assets/icons/Mail.svg": "6b876f2539a1946b1a946e7a5646e909",
"assets/assets/icons/User.svg": "737d49c1953f8098f618d523b45e5657",
"assets/assets/images/aboutus.gif": "89da2a07ac371414d37239a82506616f",
"assets/assets/images/aboutus.jpg": "c58a15ea4da82d066a32ba3cbc3eff6d",
"assets/assets/images/american_express.png": "fac1ed63030230003fa52ee8f98aa8dc",
"assets/assets/images/background.png": "68b18e0a480b249c34aae78b6c72d543",
"assets/assets/images/banner.jpg": "f1e3223746133ca7379dea73692a6256",
"assets/assets/images/bg.jpg": "39a94862f3e83f0e991c0838bd27e864",
"assets/assets/images/calender.png": "807be0b075e015def2bc6ff00c8fdf21",
"assets/assets/images/card_cvv.png": "bcfdc3cf11036e9c79c95cd02768c6ff",
"assets/assets/images/dinners_club.png": "24450426cbb1e5b657356b6cca621956",
"assets/assets/images/discover.png": "c3a58509fe14ba54b0ca0ff29ee5619d",
"assets/assets/images/jcb.png": "82658437070a16f35238c2f989a00c2a",
"assets/assets/images/logo.png": "ee634cecbc5518082233f8451059f5be",
"assets/assets/images/logoupd.png": "bf11de62f697ff77ab31d9a56b91e3dd",
"assets/assets/images/mastercard.png": "6aecef820a950ef57140f79e07da916a",
"assets/assets/images/mission.gif": "8a6502740d5168ea07931f23c4c0f4df",
"assets/assets/images/paystack.png": "4a7ac4e8e0a890715d732e007a79864d",
"assets/assets/images/verve.png": "d9e7f9a5b6987ec61b7c2d0bd7db1271",
"assets/assets/images/visa.png": "a8b02279da904c1f40e041b20cbaf49c",
"assets/FontManifest.json": "421504d10c5cd3233d370de5dafc7974",
"assets/fonts/MaterialIcons-Regular.otf": "4e6447691c9509f7acdbf8a931a85ca1",
"assets/NOTICES": "cc6c7115e979096bb6fdaeec3c964b59",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "6d342eb68f170c97609e9da345464e5e",
"assets/packages/fluentui_system_icons/fonts/FluentSystemIcons-Filled.ttf": "f7b0c0c1d5ae36fae1a40d9902786844",
"assets/packages/fluentui_system_icons/fonts/FluentSystemIcons-Regular.ttf": "47319ab4dfde6e27a4a79faed7a5890d",
"canvaskit/canvaskit.js": "43fa9e17039a625450b6aba93baf521e",
"canvaskit/canvaskit.wasm": "04ed3c745ff1dee16504be01f9623498",
"canvaskit/profiling/canvaskit.js": "f3bfccc993a1e0bfdd3440af60d99df4",
"canvaskit/profiling/canvaskit.wasm": "a9610cf39260f60fbe7524a785c66101",
"favicon.png": "5dcef449791fa27946b3d35ad8803796",
"icons/android-icon-144x144.png": "ada7e610fc0a9611c48b93039875e674",
"icons/android-icon-192x192.png": "c43caf1a24b99037826218b4fded2039",
"icons/android-icon-36x36.png": "f5c2e306d18de26465f3d0713e572707",
"icons/android-icon-48x48.png": "c8cfcd529600f70dee33aa258fde8b8e",
"icons/android-icon-72x72.png": "66c6c3096dedac16f62e211fdee4190e",
"icons/android-icon-96x96.png": "35e8d3f0b4dcc7da5a953814b36ea30f",
"icons/apple-icon-114x114.png": "4be11e642a9cba8eddd272a1d68ed818",
"icons/apple-icon-120x120.png": "17f13c7241924c99bb2f4daaa007f1e7",
"icons/apple-icon-144x144.png": "ada7e610fc0a9611c48b93039875e674",
"icons/apple-icon-152x152.png": "4f6e476ddb992d5b796e1a3cf581c1bc",
"icons/apple-icon-180x180.png": "6bea1be4411f368e7445335db0514762",
"icons/apple-icon-57x57.png": "fd4b5fff07e320e132322a77810c1a29",
"icons/apple-icon-60x60.png": "24c0d5fe97bf151b7d7eb23d4e3a3580",
"icons/apple-icon-72x72.png": "66c6c3096dedac16f62e211fdee4190e",
"icons/apple-icon-76x76.png": "4e07d65eb5e90da6e57b309f799404ff",
"icons/apple-icon-precomposed.png": "38b8c1272fb3af5eeed0a8f8de4822bf",
"icons/apple-icon.png": "38b8c1272fb3af5eeed0a8f8de4822bf",
"icons/favicon-16x16.png": "112de6d4986ee9bec9e42c45e3d4bc20",
"icons/favicon-32x32.png": "5b70eba7fa713df2ed7ad0e13130b0ef",
"icons/favicon-96x96.png": "35e8d3f0b4dcc7da5a953814b36ea30f",
"icons/favicon.ico": "415f8720cf48d5c90cabab64686c9960",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"icons/ms-icon-144x144.png": "ada7e610fc0a9611c48b93039875e674",
"icons/ms-icon-150x150.png": "e78e8e3a09357df762537ff51b1448e4",
"icons/ms-icon-310x310.png": "b62b52c58569bda99219f3d3852391e4",
"icons/ms-icon-70x70.png": "f730e0586e22a0378e254f7805b14dad",
"index.html": "48ac67f03c7e7a754f9656df335bef16",
"/": "48ac67f03c7e7a754f9656df335bef16",
"main.dart.js": "0ecc8bf977d933b2b7d3d74034008bc1",
"manifest.json": "8a159ca28a3ec5da102f35df6484771f",
"styled.css": "f6dcfede460044900cf68710968affec",
"version.json": "73e4193e03f3eac3889be2d881e70ded"
};

// The application shell files that are downloaded before a service worker can
// start.
const CORE = [
  "/",
"main.dart.js",
"index.html",
"assets/NOTICES",
"assets/AssetManifest.json",
"assets/FontManifest.json"];
// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});

// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});

// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache.
        return response || fetch(event.request).then((response) => {
          cache.put(event.request, response.clone());
          return response;
        });
      })
    })
  );
});

self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});

// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}

// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
